/*
 * Decompiled with CFR 0.152.
 */
package ec.gob.sri.dimm.ats.modelo.obj.exportacion;

import ec.gob.sri.anexo.texto.util.StringUtil;
import ec.gob.sri.dimm.ats.modelo.obj.Comprobante;
import ec.gob.sri.dimm.ats.modelo.util.Util;
import ec.gob.sri.dimm.data.impl.UtilCatalogosATS;
import java.util.Map;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class ComprobanteExportacion
extends Comprobante {
    private static final long serialVersionUID = 8927883381908560518L;
    public static final String C_TIPO_COMPROBANTE = "tipoComprobante";
    public static final String C_VALOR_FOB_COMPROBANTE = "valorFobComprobante";
    @NotNull(message="Debe seleccionar el tipo de Comprobante")
    private String tipoComprobante;
    private String descripcionTipoComprobante;
    @NotNull(message="Debe ingresar el valor de Valor FOB del Comprobante Local")
    @Pattern(regexp="^((0{1})|(([1-9]{1}))([0-9]{0,11}))(\\.[0-9]{2})?$", message="El valor FOB del Comprobante Local  debe ser 12 enteros y 2 decimales. ")
    private String valorComprobanteLocal = "0.00";

    @Override
    public ComprobanteExportacion crearCopiaEdicion() {
        ComprobanteExportacion copia = new ComprobanteExportacion();
        copia.setEstablecimiento(super.getEstablecimiento());
        copia.setPuntoEmision(super.getPuntoEmision());
        copia.setSecuencial(super.getSecuencial());
        copia.setNumAutorizacion(super.getNumAutorizacion());
        copia.setFechaEmision(super.getFechaEmision());
        copia.setTipoComprobante(this.tipoComprobante);
        copia.setDescripcionTipoComprobante(this.descripcionTipoComprobante);
        copia.setValorComprobanteLocal(this.valorComprobanteLocal);
        copia.setPropietario(this.propietario);
        return copia;
    }

    @Override
    public void actualizarInformacion(Comprobante copiaEdicion) {
        ComprobanteExportacion combrobanteExportacion = (ComprobanteExportacion)copiaEdicion;
        this.setTipoComprobante(combrobanteExportacion.getTipoComprobante());
        this.setDescripcionTipoComprobante(combrobanteExportacion.getDescripcionTipoComprobante());
        this.setValorComprobanteLocal(combrobanteExportacion.getValorComprobanteLocal());
        super.actualizarInformacion(copiaEdicion);
    }

    @Override
    public Object importar(Element elemento, Map<String, Element> mapaData) {
        NodeList valorList = elemento.getElementsByTagName("establecimiento");
        Element eValor = (Element)valorList.item(0);
        this.setEstablecimiento(eValor.getTextContent());
        valorList = elemento.getElementsByTagName("puntoEmision");
        eValor = (Element)valorList.item(0);
        this.setPuntoEmision(eValor.getTextContent());
        valorList = elemento.getElementsByTagName("secuencial");
        eValor = (Element)valorList.item(0);
        this.setSecuencial(eValor.getTextContent());
        valorList = elemento.getElementsByTagName("autorizacion");
        eValor = (Element)valorList.item(0);
        this.setNumAutorizacion(eValor.getTextContent());
        valorList = elemento.getElementsByTagName("fechaEmision");
        eValor = (Element)valorList.item(0);
        this.setFechaEmision(Util.importarFecha(eValor));
        valorList = elemento.getElementsByTagName(C_TIPO_COMPROBANTE);
        eValor = (Element)valorList.item(0);
        this.tipoComprobante = eValor.getTextContent().trim();
        this.descripcionTipoComprobante = String.valueOf(this.getTipoComprobante()) + "-" + UtilCatalogosATS.crearInstancia().obtenerDescripcionComprobante(this.getTipoComprobante());
        valorList = elemento.getElementsByTagName("valorFOBComprobante");
        eValor = (Element)valorList.item(0);
        this.valorComprobanteLocal = eValor.getTextContent().trim();
        return this;
    }

    public String getTipoComprobante() {
        return this.tipoComprobante;
    }

    public String getDescripcionTipoComprobante() {
        return this.descripcionTipoComprobante;
    }

    public String getValorComprobanteLocal() {
        return this.valorComprobanteLocal;
    }

    public void setTipoComprobante(String tipoComprobante) {
        String oldValue = this.tipoComprobante;
        this.tipoComprobante = StringUtil.isNullOrEmpty((String)tipoComprobante) ? tipoComprobante : tipoComprobante.toUpperCase();
        this.firePropertyChange(C_TIPO_COMPROBANTE, oldValue, this.tipoComprobante);
    }

    public void setDescripcionTipoComprobante(String descripcionTipoComprobante) {
        this.descripcionTipoComprobante = descripcionTipoComprobante;
    }

    public void setValorComprobanteLocal(String valorComprobanteLocal) {
        String oldValue = this.valorComprobanteLocal;
        this.valorComprobanteLocal = valorComprobanteLocal;
        this.firePropertyChange(C_VALOR_FOB_COMPROBANTE, oldValue, this.valorComprobanteLocal);
    }

    public String getFactura() {
        return String.valueOf(this.getEstablecimiento()) + "-" + this.getPuntoEmision() + "-" + this.getSecuencial();
    }
}

